///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

saw.chart = new Object();

// drill:0; sawNav:1; sweNav:2
saw.chart.kInteractionDrill = 0;
saw.chart.kInteractionSAWNav = 1;
saw.chart.kInteractionSWENav = 2;

saw.chart.drillImpl = function()
{
   var info = window[arguments[0]];
   var cols = arguments[1];
   var values = arguments[2];
   
   if (info.drill.type == saw.chart.kInteractionDrill)
   {
      var tDrillInfo = new DrillInfo();

	   // if pivot chart, add page and section values if any
	   if (null != info.ptid && info.ptid != "")
	   {
	      var tPTLookup = eval("window." + info.ptid);
	      if (null != tPTLookup && null != tPTLookup.vPageValues &&
	          null != tPTLookup.vSectionValues)
	      {
	         for(var p = 0 ; p < tPTLookup.vPageValues.length ; ++p)
	         {
		         var tValue = tPTLookup.vPageValues[p];
		         if(tValue[0] != null)
			         tDrillInfo.AddValue(tValue[0], tValue[1], kDrillInfoFilterOn);
	         }

	         for(var s = 0 ; s < tPTLookup.vSectionValues.length ; ++s)
	         {
		         var tValue = tPTLookup.vSectionValues[s];
		         if(tValue[0] != null)
			         tDrillInfo.AddValue(tValue[0], tValue[1], kDrillInfoFilterOn);
	         }
	      }
	   }

      for (var i = 0; i != cols.length; ++i)
      {
         tDrillInfo.AddValue(cols[i], values[i], kDrillInfoDrillOn);
      }


	   // for debugging
	   //DisplayDrillDownInfo(tDrillInfo);

	   // first argument to function is array of view id & search id
	   DrillDown(GetDrillForm(info.sViewID), tDrillInfo);
	}
	else
	{
      var tNavInfo = new NavigateInfo();

      tNavInfo.SetSearchID(info.sSearchID);
      tNavInfo.SetViewID(info.sViewID);

      // if pivot chart, add page and section values if any
      if (null != info.ptid && info.ptid != "")
      {
         var tPTLookup = eval("window." + info.ptid);
         if (null != tPTLookup && null != tPTLookup.vPageValues &&
            null != tPTLookup.vSectionValues && null != tPTLookup.vFormulas)
         {
            for(var p = 0 ; p < tPTLookup.vPageValues.length ; ++p)
            {
               var tValue = tPTLookup.vPageValues[p];
               if(tValue[0] != null)
                  tNavInfo.AddValue('eq', tPTLookup.vFormulas[tValue[0]], tValue[1]);
            }

            for(var s = 0 ; s < tPTLookup.vSectionValues.length ; ++s)
            {
               var tValue = tPTLookup.vSectionValues[s];
               if(tValue[0] != null)
                  tNavInfo.AddValue('eq', tPTLookup.vFormulas[tValue[0]], tValue[1]);
            }
         }
      }

      for (var i = 0; i != cols.length; ++i)
         tNavInfo.AddValue('eq', info.cols[cols[i]], values[i]);


      switch (info.drill.type)
      {
         case saw.chart.kInteractionSAWNav:
         {
            tNavInfo.SetTargets(info.drill.targets);
            break;
         }
         case saw.chart.kInteractionSWENav:
         {
            tNavInfo.SetActionLink(info.drill.sSWEView, info.drill.sSWEApplet, info.drill.sSWESrcColumnID);
            break;
         }
      }
      
      info.oNavObject = tNavInfo;
      NQNavigate(null, info);
	}
};

saw.chart.catDr = function()
{
   saw.chart.drillImpl(arguments[0],arguments[1],arguments[2]);
};

saw.chart.serDr = function(x,y)
{
   saw.chart.drillImpl(arguments[0],arguments[1],arguments[2]);
};

saw.chart.dr = function()
{
   var cols = null;
   var values = null;

   if (arguments.length == 5)
   {
      cols = arguments[1].concat(arguments[2]);
      values = arguments[3].concat(arguments[4]);
   }
   else
   {
      cols = arguments[1];
      values = arguments[2];
   }

   saw.chart.drillImpl(arguments[0], cols, values);
};